unsigned char get_block_i2c_device_address(unsigned int address)
{
 return (0b10100000 | ((address & 0xF00) >> 7));
}


unsigned char get_byte_address(unsigned int address)
{
 return (address & 0x0FF);
}


void write_EEPROM(unsigned int address, unsigned char value)
{
 unsigned char	device_address, byte_address, ok;

 device_address	= get_block_i2c_device_address(address);
 byte_address	= get_byte_address(address);

 ok = 0;

 while(!ok)
 {						  
  ok = 1;
  while(i2c_WriteTo(device_address));
  if (i2c_PutByte(byte_address)) ok = 0;
  if (i2c_PutByte(value))       ok = 0;
  i2c_Stop();
  DelayMs(20);
 }
}

unsigned char read_EEPROM(unsigned int address)
{
 unsigned char	device_address, byte_address, ok, help;
  
 device_address	= get_block_i2c_device_address(address);
 byte_address	= get_byte_address(address);

 ok = 0;
 
 while(!ok)
 {
  ok = 1;
  i2c_Stop();
  while(i2c_WriteTo(device_address));
  if (i2c_PutByte(byte_address))     ok = 0;
  if (i2c_ReadFrom(device_address)) ok = 0;
  help =  i2c_GetByte(1);
  i2c_Stop();
 }
 return help;
}



