void init_internal_ADC()
{
 DDRG3 = 1;		//set AN0 pin input necessary for analog input
 DDRG2 = 1;		//set AN1 pin input necessary for analog input
 DDRF4 = 1;		//set AN8 pin input necessary for analog input
 DDRF5 = 1;		//set AN9 pin input necessary for analog input

 PCFG3 = 1;		
 PCFG2 = 1;		//set AN0/1/8/9 as analog and the rest digital
 PCFG1 = 0;

 ADCS1 = 1;		//select Fosc/64 conversation clock
 ADCS0 = 0; 

 PCFG0 = 1;		//use voltage reference from AN0/1 
 ADFM  = 1;		//result format selected as 6MSB of ADRESH are read as 0 

 ADON  = 1;		//switch internal ADC module on
}

unsigned int AN8()
{
 ADCON0 = 0b10000001;	//select chanel AN8

 DelayUs(80); 
 DelayUs(80);		//wait 240Us minimum required acquisition time
 DelayUs(80);

 GO = 1;		//start conversion
 while(GO);		//wait until conversion is finished

 return ADRESH*256 + ADRESL;
}

unsigned int AN9()
{
 ADCON0 = 0b10010001;	//select chanel AN9

 DelayUs(80); 
 DelayUs(80);		//wait 240Us minimum required acquisition time
 DelayUs(80);

 GO = 1;		//start conversion
 while(GO);		//wait until conversion is finished

 return ADRESH*256 + ADRESL;
}


unsigned long int AN9_advanced_100()	//this function gives a 10 times higher, 10 times more accurate result
{
 unsigned long int	summe = 0;
 unsigned char		i;

 ADCON0 = 0b10010001;	//select chanel AN9

 DelayUs(80); 
 DelayUs(80);		//wait 240Us minimum required acquisition time
 DelayUs(80);

 for (i=0; i<100; i++)
 {
  GO = 1;		//start conversion
  while(GO);		//wait until conversion is finished
  summe = summe + ADRESH*256 + ADRESL;
 }
 return summe;
}
