//  This functions are displaying an LCD pointer on a 4x16 LCD display
//  the input is a value between -91 .. +91 everything over or under will
//  display -91 or +91.
//  At the moment the function has trouble displaying the -5. A solution 
//  could be to be to say "if (position == -5) position = -4;".
//  The rest is OK.

void lcd_define_character(char address, unsigned char direction, const unsigned char *pattern, unsigned char bruchteil)
{
 char i;				//LCD_DefineCharacter: Define dot pattern for user-defined character.
	
 LCD_RW = 0;				//inputs: address = address of character (0x00-0x07)
 LCD_RS = 0;				//pattern = pointer to 8-byte array containing the dot pattern
 lcd_write(0x40 + (address << 3));	//direction defines if the characters are y-mirror or not
 LCD_RS = 1;

 if (direction == negative)
 {
  pattern = pattern + (bruchteil-1)*8 + 7;
  for(i=0; i<8; i++) lcd_write(*pattern--);	//non mirrored case
 }
 else 
 {
  pattern = pattern + (bruchteil-1)*8;
  for(i=0; i<8; i++) lcd_write(*pattern++);	//mirrored case
 }
}


void zeiger(signed char position)
{
 unsigned char rest, voll, i;

 if (position > 91) position = 91;
 if (position <-91) position = -91;
 
 lcd_define_character(0, positive, vertical, 8);

 if (position == 0)
 {
  lcd_define_character(7, positive, vertical, 1);
  lcd_define_character(6, negative, vertical, 1);
  gotoxy(1,2); putch(7);
  gotoxy(1,3); putch(6);
  gotoxy(1,1); for(i=0; i<16; i++) putch(' ');
  gotoxy(1,4); for(i=0; i<16; i++) putch(' ');
 }

 if (position > 16) 
 {
  lcd_define_character(1, positive, edge, 8);
  lcd_define_character(2, positive, horizontal, 5);

  gotoxy(1,2); putch(0);			//place a full character
  gotoxy(1,1); putch(1);			//place a full edge
  rest = position - 16;
  voll = 1;
  while(rest>5)
  {
   voll++;
   rest = rest-5;				//place full characters
   putch(2);   
  }
  if (!(rest==0))
  {
   lcd_define_character(3, positive, horizontal, rest);
   gotoxy(voll+1, 1);
   putch(3);					//place the rest character
   voll++;
  }
  for(i=0; i<(16-voll); i++) putch(' ');	//clear the rest of the characters in the first line
  gotoxy(1,3); putch(' ');			//clear the rest of the character  in the third line
  gotoxy(1,4); for(i=0; i<16; i++) putch(' ');  //clear the rest of the characters in the fourth line
 }

 if (position < -16) 
 {
  position = - position;
  lcd_define_character(1, negative, edge, 8);
  lcd_define_character(2, negative, horizontal, 5);

  gotoxy(1,3); putch(0);			//place a full character
  gotoxy(1,4); putch(1);			//place a full edge
  rest = position - 16;
  voll = 1;
  while(rest>5)
  {
   voll++;
   rest = rest-5;				//place full characters
   putch(2);   
  }
  if (!(rest==0))
  {
   lcd_define_character(3, negative, horizontal, rest);
   gotoxy(voll+1, 4);
   putch(3);					//place the rest character
   voll++;
  }
  for(i=0; i<(16-voll); i++) putch(' ');	//clear the rest of the characters in the first line
  gotoxy(1,2); putch(' ');			//clear the rest of the character  in the third line
  gotoxy(1,1); for(i=0; i<16; i++) putch(' ');  //clear the rest of the characters in the fourth line
  position = - position;
 }

 if (position > 8) if(position < 17)
 {
  lcd_define_character(1, positive, edge, position - 8);
  gotoxy(1,2); putch(0);
  gotoxy(1,1); putch(1);
  for(i=0; i < 15; i++) putch(' ');
  gotoxy(1,3); putch(' ');
  gotoxy(1,4); for(i=0; i<16; i++) putch(' ');
 }

 if (position < -8) if(position > -17)
 {
  lcd_define_character(1, negative, edge, - position - 8);
  gotoxy(1,3); putch(0);
  gotoxy(1,4); putch(1);
  for(i=0; i < 15; i++) putch(' ');
  gotoxy(1,2); putch(' ');
  gotoxy(1,1); for(i=0; i<16; i++) putch(' ');
 }
 if (position > 0) if(position < 9)
 {
  lcd_define_character(1, positive, vertical, position);
  gotoxy(1,2); putch(1);
  gotoxy(1,3); putch(' ');
  gotoxy(1,1); for(i=0; i<16; i++) putch(' ');
  gotoxy(1,4); for(i=0; i<16; i++) putch(' ');
 }
 if (position < 0) if(position > -9)
 {
  lcd_define_character(1, negative, vertical, - position);
  gotoxy(1,3); putch(1);
  gotoxy(1,2); putch(' ');
  gotoxy(1,1); for(i=0; i<16; i++) putch(' ');
  gotoxy(1,4); for(i=0; i<16; i++) putch(' ');
 }
}




