void save_float_to_EEPROM(float get_number, unsigned char EEPROM_adress)
{
 union_f_number	float_number;	

 float_number.number = get_number;

 write_eeprom(EEPROM_adress+0, float_number.bytes.byte0);
 write_eeprom(EEPROM_adress+1, float_number.bytes.byte1);
 write_eeprom(EEPROM_adress+2, float_number.bytes.byte2);
}

void save_unsigned_int_to_EEPROM(unsigned int get_number, unsigned char EEPROM_adress)
{
 union_i_number	int_number;	

 int_number.number = get_number;

 write_eeprom(EEPROM_adress+0, int_number.bytes.byte0);
 write_eeprom(EEPROM_adress+1, int_number.bytes.byte1);
}

void save_unsigned_char_to_EEPROM(unsigned char uchar_number, unsigned char EEPROM_adress)
{
 write_eeprom(EEPROM_adress, uchar_number);
}


float restore_float_from_EEPROM(unsigned char EEPROM_adress)
{
 union_f_number	float_number;	

 float_number.bytes.byte0 = read_eeprom(EEPROM_adress+0);
 float_number.bytes.byte1 = read_eeprom(EEPROM_adress+1);
 float_number.bytes.byte2 = read_eeprom(EEPROM_adress+2);

 return float_number.number;
} 

unsigned int restore_unsigned_int_from_EEPROM(unsigned char EEPROM_adress)
{
 union_i_number	int_number;	

 int_number.bytes.byte0 = read_eeprom(EEPROM_adress+0);
 int_number.bytes.byte1 = read_eeprom(EEPROM_adress+1);

 return int_number.number;
} 

unsigned char restore_unsigned_char_from_EEPROM(unsigned char EEPROM_adress)
{
 unsigned char	uchar_number;

 uchar_number = read_eeprom(EEPROM_adress);

 return uchar_number;
} 

