//ADC_0 pins
static bit      A0	@ (unsigned)&PORTF*8+0;
static bit      SCLK    @ (unsigned)&PORTF*8+1;
static bit      SDATA	@ (unsigned)&PORTG*8+1;
static bit      DRDY    @ (unsigned)&PORTG*8+0;
static bit      RFS     @ (unsigned)&PORTG*8+4;
static bit      TFS     @ (unsigned)&PORTG*8+5;

//ADC_0 data directions
static bank1 bit        DDRA0    @ (unsigned)&DDRF*8+0;
static bank1 bit        DDRSCLK  @ (unsigned)&DDRF*8+1;
static bank1 bit        DDRSDATA @ (unsigned)&DDRG*8+1;
static bank1 bit        DDRDRDY  @ (unsigned)&DDRG*8+0;
static bank1 bit        DDRRFS   @ (unsigned)&DDRG*8+4;
static bank1 bit        DDRTFS   @ (unsigned)&DDRG*8+5;


//ADC_1 pins
static bit      A0_1	@ (unsigned)&PORTF*8+7;
static bit      SCLK_1  @ (unsigned)&PORTF*8+6;
static bit      SDATA_1	@ (unsigned)&PORTF*8+3;
static bit      DRDY_1  @ (unsigned)&PORTF*8+2;
static bit      RFS_1   @ (unsigned)&PORTG*8+7;
static bit      TFS_1   @ (unsigned)&PORTG*8+6;

//ADC_1 data directions
static bank1 bit        DDRA0_1    @ (unsigned)&DDRF*8+7;
static bank1 bit        DDRSCLK_1  @ (unsigned)&DDRF*8+6;
static bank1 bit        DDRSDATA_1 @ (unsigned)&DDRF*8+3;
static bank1 bit        DDRDRDY_1  @ (unsigned)&DDRF*8+2;
static bank1 bit        DDRRFS_1   @ (unsigned)&DDRG*8+7;
static bank1 bit        DDRTFS_1   @ (unsigned)&DDRG*8+6;



#define	SCLK_strobe	((SCLK   = 1),(SCLK   = 1),(SCLK   = 0))	//high time has to be 200ns; this mascro generats 250ns high time
#define	SCLK_strobe_1	((SCLK_1 = 1),(SCLK_1 = 1),(SCLK_1 = 0))	//high time has to be 200ns; this mascro generats 250ns high time


void AD7711_write_controll_register(unsigned long int controll_reg)
{
 unsigned char 		i;
 unsigned long int 	mask = 0b100000000000000000000000;

 DDRSDATA = 0;		//serial data direction is output (from PIC to AD7711)

 TFS  = 1;		//TFS is low active, so it must be disabeld by setting high
 RFS  = 1;		//RFS is low active, so it must be disabled by setting high
 A0   = 1;		//see data sheet page 25 

 A0   = 0;		//read-write operation to the CONTROL register
 TFS  = 0; 		//start transmision with falling edge of TFS
 for(i=0; i<24; i++)
 {
  if (mask & controll_reg) SDATA = 1;
   else SDATA = 0;  
  SCLK_strobe;
  mask = mask / 2;  
 }
 TFS = 1;		//set TFS high (again inactive)
 DDRSDATA = 1;		//serial data direction is input (from AD7711 to PIC)
}

void AD7711_write_controll_register_1(unsigned long int controll_reg)
{
 unsigned char 		i;
 unsigned long int 	mask = 0b100000000000000000000000;

 DDRSDATA_1 = 0;		//serial data direction is output (from PIC to AD7711)

 TFS_1  = 1;		//TFS is low active, so it must be disabeld by setting high
 RFS_1  = 1;		//RFS is low active, so it must be disabled by setting high
 A0_1   = 1;		//see data sheet page 25 

 A0_1   = 0;		//read-write operation to the CONTROL register
 TFS_1  = 0; 		//start transmision with falling edge of TFS
 for(i=0; i<24; i++)
 {
  if (mask & controll_reg) SDATA_1 = 1;
   else SDATA_1 = 0;  
  SCLK_strobe_1;
  mask = mask / 2;  
 }
 TFS_1 = 1;		//set TFS high (again inactive)
 DDRSDATA_1 = 1;		//serial data direction is input (from AD7711 to PIC)
}

unsigned long int AD7711_read_controll_register()
{
 unsigned char i;
 unsigned long int number, mask;

 RFS = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 TFS = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 A0  = 0;				//acces to controll register (see data sheet page 25 )

 RFS = 0; 				//SDATA line becomes active after RFS goes low
 number = 0;				//set all bits in this help variable 0
 mask = 0b100000000000000000000000;	//init mask number
 for(i=0; i<24; i++)
 {
  if (SDATA) number = number | mask;	//if SDATA high, then set bit
  SCLK_strobe;				//clock
  mask = mask / 2;
 } 

 RFS = 1;				//disable serial output line
 return number;
}

unsigned long int AD7711_read_controll_register_1()
{
 unsigned char i;
 unsigned long int number, mask;

 RFS_1 = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 TFS_1 = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 A0_1  = 0;				//acces to controll register (see data sheet page 25 )

 RFS_1 = 0; 				//SDATA line becomes active after RFS goes low
 number = 0;				//set all bits in this help variable 0
 mask = 0b100000000000000000000000;	//init mask number
 for(i=0; i<24; i++)
 {
  if (SDATA_1) number = number | mask;	//if SDATA high, then set bit
  SCLK_strobe_1;				//clock
  mask = mask / 2;
 } 

 RFS_1 = 1;				//disable serial output line
 return number;
}


unsigned long int ADC_value()
{
 unsigned char i;
 unsigned long int number, mask;

 RFS = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 TFS = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 A0  = 1;				//acces to calibration or data register (see data sheet page 25 )
 while(DRDY);				//wait until data ready

 RFS = 0; 				//SDATA line becomes active after RFS goes low
 number = 0;				//set all bits in this help variable 0
 mask = 0b100000000000000000000000;	//init mask number
 for(i=0; i<24; i++)
 {
  if (SDATA) number = number | mask;	//if SDATA high, then set bit
  SCLK_strobe;				//clock
  mask = mask / 2;
 } 

 RFS = 1;				//disable serial output line
 return number;
}

unsigned long int ADC_value_1()
{
 unsigned char i;
 unsigned long int number, mask;

 RFS_1 = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 TFS_1 = 1;				//is low active and has to be 0 for reading operations (see data sheet page 21-24)
 A0_1  = 1;				//acces to calibration or data register (see data sheet page 25 )
 while(DRDY_1);				//wait until data ready

 RFS_1 = 0; 				//SDATA line becomes active after RFS goes low
 number = 0;				//set all bits in this help variable 0
 mask = 0b100000000000000000000000;	//init mask number
 for(i=0; i<24; i++)
 {
  if (SDATA_1) number = number | mask;	//if SDATA high, then set bit
  SCLK_strobe_1;				//clock
  mask = mask / 2;
 } 

 RFS_1 = 1;				//disable serial output line
 return number;
}


void AD7711_self_calibration()			//Active self calibration 
{						//with MD2 MD1 MD0
 unsigned long int 	controll_reg;		//      0   0   1

 controll_reg = AD7711_read_controll_register();
 controll_reg = controll_reg | 0b001000000000000000000000;
 controll_reg = controll_reg & 0b001111111111111111111111;
 AD7711_write_controll_register(controll_reg);
 while(DRDY);
}

void AD7711_self_calibration_1()		//Active self calibration 
{						//with MD2 MD1 MD0
 unsigned long int 	controll_reg;		//      0   0   1

 controll_reg = AD7711_read_controll_register_1();
 controll_reg = controll_reg | 0b001000000000000000000000;
 controll_reg = controll_reg & 0b001111111111111111111111;
 AD7711_write_controll_register_1(controll_reg);
 while(DRDY_1);
}

void AD7711_select_chanel(unsigned char chanel)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register();
 if (chanel==1) controll_reg = controll_reg & 0b111111011111111111111111;
 if (chanel==2) controll_reg = controll_reg | 0b000000100000000000000000;
 AD7711_write_controll_register(controll_reg);
}

void AD7711_select_chanel_1(unsigned char chanel)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register_1();
 if (chanel==1) controll_reg = controll_reg & 0b111111011111111111111111;
 if (chanel==2) controll_reg = controll_reg | 0b000000100000000000000000;
 AD7711_write_controll_register_1(controll_reg);
}

void AD7711_select_gain(unsigned char gain)
{
 unsigned long int 	controll_reg;
 unsigned char	G0, G1, G2;

 controll_reg = AD7711_read_controll_register();
 switch(gain)
 {
  case 	1   	:	{G2 = 0; G1 = 0; G0 = 0;}	break;
  case	2	:	{G2 = 0; G1 = 0; G0 = 1;}	break;
  case	4	:	{G2 = 0; G1 = 1; G0 = 0;}	break;		//see data sheet page 10
  case	8	:	{G2 = 0; G1 = 1; G0 = 1;}	break;
  case	16	:	{G2 = 1; G1 = 0; G0 = 0;}	break;
  case	32	:	{G2 = 1; G1 = 0; G0 = 1;}	break;
  case  64	:	{G2 = 1; G1 = 1; G0 = 0;}	break;
  case  128	:	{G2 = 1; G1 = 1; G0 = 1;}	break;
 } 

 if (G0==0) controll_reg = controll_reg & 0b111110111111111111111111;
       else controll_reg = controll_reg | 0b000001000000000000000000;
 if (G1==0) controll_reg = controll_reg & 0b111101111111111111111111;
       else controll_reg = controll_reg | 0b000010000000000000000000;
 if (G2==0) controll_reg = controll_reg & 0b111011111111111111111111;
       else controll_reg = controll_reg | 0b000100000000000000000000;
 AD7711_write_controll_register(controll_reg);
 AD7711_self_calibration();
}

void AD7711_select_gain_1(unsigned char gain)
{
 unsigned long int 	controll_reg;
 unsigned char	G0, G1, G2;

 controll_reg = AD7711_read_controll_register_1();
 switch(gain)
 {
  case 	1   	:	{G2 = 0; G1 = 0; G0 = 0;}	break;
  case	2	:	{G2 = 0; G1 = 0; G0 = 1;}	break;
  case	4	:	{G2 = 0; G1 = 1; G0 = 0;}	break;		//see data sheet page 10
  case	8	:	{G2 = 0; G1 = 1; G0 = 1;}	break;
  case	16	:	{G2 = 1; G1 = 0; G0 = 0;}	break;
  case	32	:	{G2 = 1; G1 = 0; G0 = 1;}	break;
  case  64	:	{G2 = 1; G1 = 1; G0 = 0;}	break;
  case  128	:	{G2 = 1; G1 = 1; G0 = 1;}	break;
 } 

 if (G0==0) controll_reg = controll_reg & 0b111110111111111111111111;
       else controll_reg = controll_reg | 0b000001000000000000000000;
 if (G1==0) controll_reg = controll_reg & 0b111101111111111111111111;
       else controll_reg = controll_reg | 0b000010000000000000000000;
 if (G2==0) controll_reg = controll_reg & 0b111011111111111111111111;
       else controll_reg = controll_reg | 0b000100000000000000000000;
 AD7711_write_controll_register_1(controll_reg);
 AD7711_self_calibration_1();
}


void AD7711_power_down(unsigned char status)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register();
 if (status==enabled)  controll_reg = controll_reg | 0b000000010000000000000000;
 if (status==disabled) controll_reg = controll_reg & 0b111111101111111111111111;
 AD7711_write_controll_register(controll_reg);
}

void AD7711_power_down_1(unsigned char status)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register_1();
 if (status==enabled)  controll_reg = controll_reg | 0b000000010000000000000000;
 if (status==disabled) controll_reg = controll_reg & 0b111111101111111111111111;
 AD7711_write_controll_register_1(controll_reg);
}


void AD7711_word_length(unsigned char length)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register();
 if (length==16) controll_reg = controll_reg & 0b111111110111111111111111;
 if (length==24) controll_reg = controll_reg | 0b000000001000000000000000;
 AD7711_write_controll_register(controll_reg);
}

void AD7711_word_length_1(unsigned char length)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register_1();
 if (length==16) controll_reg = controll_reg & 0b111111110111111111111111;
 if (length==24) controll_reg = controll_reg | 0b000000001000000000000000;
 AD7711_write_controll_register_1(controll_reg);
}

void AD7711_burn0(unsigned char status)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register();
 if (status==enabled)  controll_reg = controll_reg | 0b000000000010000000000000;
 if (status==disabled) controll_reg = controll_reg & 0b111111111101111111111111;
 AD7711_write_controll_register(controll_reg);
}

void AD7711_burn0_1(unsigned char status)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register_1();
 if (status==enabled)  controll_reg = controll_reg | 0b000000000010000000000000;
 if (status==disabled) controll_reg = controll_reg & 0b111111111101111111111111;
 AD7711_write_controll_register_1(controll_reg);
}

void AD7711_polarity(unsigned char status)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register();
 if (status==unipolar) controll_reg = controll_reg | 0b000000000001000000000000;
 if (status==bipolar)  controll_reg = controll_reg & 0b111111111110111111111111;
 AD7711_write_controll_register(controll_reg);
 AD7711_self_calibration();
}

void AD7711_polarity_1(unsigned char status)
{
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register_1();
 if (status==unipolar) controll_reg = controll_reg | 0b000000000001000000000000;
 if (status==bipolar)  controll_reg = controll_reg & 0b111111111110111111111111;
 AD7711_write_controll_register_1(controll_reg);
 AD7711_self_calibration_1();
}

void AD7711_set_first_filter_Notch_frequency_Hz(unsigned int f_first_Notch)
{
 unsigned long int 	code;
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register();
 switch (f_first_Notch)
 {
  case	10	:	code = 1953; break;
  case 	25	:	code =  781; break;	//code = AD7711clk / 512 / F_first_Notch
  case	50	:	code =  391; break;	//see therfore data sheet page 10
  case  100 	:	code =  195; break;
 }
 controll_reg = controll_reg & 0xFFF000;	//clear all FS-bits
 controll_reg = controll_reg | code;		//set all neseccary controll FS-bits
 AD7711_write_controll_register(controll_reg);
 AD7711_self_calibration();
}

void AD7711_1_set_first_filter_Notch_frequency_Hz(unsigned int f_first_Notch)
{
 unsigned long int 	code;
 unsigned long int 	controll_reg;

 controll_reg = AD7711_read_controll_register_1();
 switch (f_first_Notch)
 {
  case	10	:	code = 1953; break;
  case 	25	:	code =  781; break;	//code = AD7711clk / 512 / F_first_Notch
  case	50	:	code =  391; break;	//see therfore data sheet page 10
  case  100 	:	code =  195; break;
 }
 controll_reg = controll_reg & 0xFFF000;	//clear all FS-bits
 controll_reg = controll_reg | code;		//set all neseccary controll FS-bits
 AD7711_write_controll_register_1(controll_reg);
 AD7711_self_calibration_1();
}

void init_AD7711()
{
 DDRA0    = 0;
 DDRSCLK  = 0;			// 0 = output	1 = input
 DDRSDATA = 0;
 DDRDRDY  = 1;
 DDRRFS   = 0;
 DDRTFS   = 0;

 TFS  = 1;			//TFS is low active, so it must be disabeld by setting high
 RFS  = 1;			//RFS is low active, so it must be disabled by setting high
 A0   = 1;			//acces to calibration or data register (see data sheet page 25 )
 SCLK = 0;			//the serial lock line should be low between read and write operations (see datasheat page 23)
 

 AD7711_power_down(disabled);
 AD7711_burn0(disabled);			
 AD7711_set_first_filter_Notch_frequency_Hz(10);
 AD7711_word_length(24);			
 AD7711_select_gain(1);				//0..5V range
 AD7711_polarity(unipolar);			//only positive voltages
 AD7711_select_chanel(1);			//chanel 1 is used

 AD7711_self_calibration();
}

void init_AD7711_1()
{
 DDRA0_1    = 0;
 DDRSCLK_1  = 0;			// 0 = output	1 = input
 DDRSDATA_1 = 0;
 DDRDRDY_1  = 1;
 DDRRFS_1   = 0;
 DDRTFS_1   = 0;

 TFS_1  = 1;			//TFS is low active, so it must be disabeld by setting high
 RFS_1  = 1;			//RFS is low active, so it must be disabled by setting high
 A0_1   = 1;			//acces to calibration or data register (see data sheet page 25 )
 SCLK_1 = 0;			//the serial lock line should be low between read and write operations (see datasheat page 23)
 

 AD7711_power_down_1(disabled);
 AD7711_burn0_1(disabled);
 AD7711_1_set_first_filter_Notch_frequency_Hz(10);
 AD7711_word_length_1(24);
 AD7711_select_gain_1(1);			//0..5V range
 AD7711_polarity_1(unipolar);			//only positive voltages
 AD7711_select_chanel_1(1);			//chanel 1 is used

 AD7711_self_calibration_1();
}






