/*
 *	Header file for the Microchip :
 *	PIC 17c752 chip
 *	PIC 17c756 chip
 *	PIC 17C756A chip
 *	PIC 17C762 chip
 *	PIC 17C766 chip
 *	High-end Microcontroller
 */

#define CONFIG_ADDR	0xFE00
#define FOSC0		0x01
#define FOSC1		0x02
#define WDTPS0		0x04
#define WDTPS1		0x08
#define PM0		0x10
#define PM1		0x40
#define BODEN		0x4000
#define PM2 		0x8000

/* PM2, PM1, PM0  Processor mode select */
#define PROTECT		0x0			/* code protected microcontroller mode */
#define MICROPROCESSOR	(PM0 | PM1 | PM2)	/* microprocessor mode */
#define MICROCONTROLLER	(PM1 | PM2)		/* microcontroller mode */
#define EXT_MICROCTRL	(PM0 | PM2)		/* extended microcontroller mode */

static 		unsigned char FSR0	@ 0x01;
static volatile	unsigned char PCL	@ 0x02;
static volatile	unsigned char PCLATH	@ 0x03;
static volatile	unsigned char ALUSTA	@ 0x04;
static 		unsigned char T0STA	@ 0x05;
static volatile	unsigned char CPUSTA	@ 0x06;
static volatile	unsigned char INTSTA	@ 0x07;
static volatile	unsigned char INDF1	@ 0x08;
static 		unsigned char FSR1	@ 0x09;
static volatile	unsigned char WREG	@ 0x0A;
static volatile	unsigned char TMR0L	@ 0x0B;
static volatile	unsigned char TMR0H	@ 0x0C;
static volatile unsigned int  TMR0	@ 0x0B;
static volatile	unsigned char TBLPTRL	@ 0x0D;
static volatile	unsigned char TBLPTRH	@ 0x0E;
static 		unsigned char BSR	@ 0x0F;
static volatile	unsigned char PRODL	@ 0x18;
static volatile	unsigned char PRODH	@ 0x19;

	/*  Bank 0  */
static volatile unsigned char 	PORTA	@ 0x10;
static volatile unsigned char 	DDRB	@ 0x11;
static volatile unsigned char 	PORTB	@ 0x12;
static volatile	unsigned char 	RCSTA1	@ 0x13;
static volatile	unsigned char 	RCREG1	@ 0x14;
static volatile	unsigned char 	TXSTA1	@ 0x15;
static 		unsigned char 	TXREG1	@ 0x16;
static 		unsigned char 	SPBRG1	@ 0x17;

	/*  Bank 1  */
static volatile	unsigned char 	DDRC	@ 0x110;
static volatile	unsigned char 	PORTC	@ 0x111;
static volatile	unsigned char 	DDRD	@ 0x112;
static volatile	unsigned char 	PORTD	@ 0x113;
static volatile	unsigned char 	DDRE	@ 0x114;
static volatile	unsigned char 	PORTE	@ 0x115;
static volatile	unsigned char 	PIR1	@ 0x116;
static 		unsigned char 	PIE1	@ 0x117;

	/*  Bank 2  */
static volatile	unsigned char 	TMR1	@ 0x210;
static volatile	unsigned char 	TMR2	@ 0x211;
static volatile	unsigned char 	TMR3L	@ 0x212;
static volatile	unsigned char 	TMR3H	@ 0x213;
static		unsigned char 	PR1	@ 0x214;
static		unsigned char 	PR2	@ 0x215;
static volatile	unsigned char 	PR3L	@ 0x216;
static volatile	unsigned char 	PR3H	@ 0x217;

	/*  Bank 3  */
static		unsigned char 	PW1DCL	@ 0x310;
static		unsigned char 	PW2DCL	@ 0x311;
static		unsigned char 	PW1DCH	@ 0x312;
static		unsigned char 	PW2DCH	@ 0x313;
static volatile	unsigned char 	CA2L	@ 0x314;
static volatile	unsigned char 	CA2H	@ 0x315;
static		unsigned char 	TCON1	@ 0x316;
static volatile	unsigned char 	TCON2	@ 0x317;
	
	/*  Bank 4 */
static		unsigned char 	PIR2	@ 0x410;
static		unsigned char 	PIE2	@ 0x411;
static volatile	unsigned char 	RCSTA2	@ 0x413;
static volatile	unsigned char 	RCREG2	@ 0x414;
static volatile	unsigned char 	TXSTA2	@ 0x415;
static volatile	unsigned char 	TXREG2	@ 0x416;
static		unsigned char 	SPBRG2	@ 0x417;

	/*  Bank 5  */
static volatile	unsigned char 	DDRF	@ 0x510;
static volatile	unsigned char 	PORTF	@ 0x511;
static volatile	unsigned char 	DDRG	@ 0x512;
static volatile	unsigned char 	PORTG	@ 0x513;
static volatile	unsigned char 	ADCON0	@ 0x514;
static		unsigned char 	ADCON1	@ 0x515;
static volatile	unsigned char 	ADRESL	@ 0x516;
static volatile	unsigned char 	ADRESH	@ 0x517;
static volatile	unsigned int	ADRES	@ 0x516;	// word version

	/*  Bank 6  */
static		unsigned char 	SSPADD	@ 0x610;
static volatile	unsigned char 	SSPCON1	@ 0x611;
static volatile	unsigned char 	SSPCON2	@ 0x612;
static volatile	unsigned char 	SSPSTAT	@ 0x613;
static volatile	unsigned char 	SSPBUF	@ 0x614;

	/*  Bank 7  */
static		unsigned char 	PW3DCL	@ 0x710;
static		unsigned char 	PW3DCH	@ 0x711;
static volatile	unsigned char 	CA3L	@ 0x712;
static volatile	unsigned char 	CA3H	@ 0x713;
static volatile	unsigned char 	CA4L	@ 0x714;
static volatile	unsigned char 	CA4H	@ 0x715;
static volatile	unsigned char 	TCON3	@ 0x716;

#if defined(_17C762) || defined(_17C766)
	/* Bank 8  */
static volatile unsigned char	DDRH	@0x810;
static volatile unsigned char	PORTH	@0x811;
static volatile unsigned char	DDRJ	@0x812;
static volatile unsigned char	PORTJ	@0x813;
#endif

	/* Bank 15 */
static		unsigned char 	TSTMD1	@ 0xF14;
static		unsigned char 	TSTMD2	@ 0xF16;

/*      ALUSTA bits     */
static bit      FS3     @ (unsigned)&ALUSTA*8+7;
static bit      FS2     @ (unsigned)&ALUSTA*8+6;
static bit      FS1     @ (unsigned)&ALUSTA*8+5;
static bit      FS0     @ (unsigned)&ALUSTA*8+4;
static bit      OV      @ (unsigned)&ALUSTA*8+3;
static bit      ZERO    @ (unsigned)&ALUSTA*8+2;
static bit      DC      @ (unsigned)&ALUSTA*8+1;
static bit      CARRY   @ (unsigned)&ALUSTA*8+0;

/*	T0STA bits	*/
static 		bit	INTEDG	@ (unsigned)&T0STA*8+7;
static 		bit	T0SE	@ (unsigned)&T0STA*8+6;
static 		bit	T0CS	@ (unsigned)&T0STA*8+5;
static 		bit	PS3	@ (unsigned)&T0STA*8+4;
static 		bit	PS2	@ (unsigned)&T0STA*8+3;
static 		bit	PS1	@ (unsigned)&T0STA*8+2;
static 		bit	PS0	@ (unsigned)&T0STA*8+1;

/*	CPUSTA bits	*/
static volatile	bit	STKAV	@ (unsigned)&CPUSTA*8+5;
static volatile	bit	GLINTD	@ (unsigned)&CPUSTA*8+4;
static volatile	bit	TO	@ (unsigned)&CPUSTA*8+3;
static volatile	bit	PD	@ (unsigned)&CPUSTA*8+2;
static volatile	bit	POR	@ (unsigned)&CPUSTA*8+1;
static volatile	bit	BOR	@ (unsigned)&CPUSTA*8+0;

/*	INTSTA bits	*/
static volatile	bit	PEIF	@ (unsigned)&INTSTA*8+7;
static volatile	bit	T0CKIF	@ (unsigned)&INTSTA*8+6;
static volatile	bit	T0IF	@ (unsigned)&INTSTA*8+5;
static volatile	bit	INTF	@ (unsigned)&INTSTA*8+4;
static 		bit	PEIE	@ (unsigned)&INTSTA*8+3;
static 		bit	T0CKIE	@ (unsigned)&INTSTA*8+2;
static 		bit	T0IE	@ (unsigned)&INTSTA*8+1;
static 		bit	INTE	@ (unsigned)&INTSTA*8+0;

/*      PORTA bits      */
static volatile bit	 RBPU	 @ (unsigned)&PORTA*8+7;
static volatile bit      RA5     @ (unsigned)&PORTA*8+5;
static volatile bit      RA4     @ (unsigned)&PORTA*8+4;
static volatile bit      RA3     @ (unsigned)&PORTA*8+3;
static volatile bit      RA2     @ (unsigned)&PORTA*8+2;
static volatile bit      RA1     @ (unsigned)&PORTA*8+1;
static volatile bit      RA0     @ (unsigned)&PORTA*8+0;

/*      PORTB bits      */
static volatile bit      RB7     @ (unsigned)&PORTB*8+7;
static volatile bit      RB6     @ (unsigned)&PORTB*8+6;
static volatile bit      RB5     @ (unsigned)&PORTB*8+5;
static volatile bit      RB4     @ (unsigned)&PORTB*8+4;
static volatile bit      RB3     @ (unsigned)&PORTB*8+3;
static volatile bit      RB2     @ (unsigned)&PORTB*8+2;
static volatile bit      RB1     @ (unsigned)&PORTB*8+1;
static volatile bit      RB0     @ (unsigned)&PORTB*8+0;

/*	RCSTA1 bits	*/
static 		bit	SPEN1	@ (unsigned)&RCSTA1*8+7;
static 		bit	RX91	@ (unsigned)&RCSTA1*8+6;
static 		bit	SREN1	@ (unsigned)&RCSTA1*8+5;
static 		bit	CREN1	@ (unsigned)&RCSTA1*8+4;
static volatile	bit	FERR1	@ (unsigned)&RCSTA1*8+2;
static volatile	bit	OERR1	@ (unsigned)&RCSTA1*8+1;
static volatile	bit	RX9D1	@ (unsigned)&RCSTA1*8+0;

/*	TXSTA1 bits	*/
static 		bit	CSRC1	@ (unsigned)&TXSTA1*8+7;
static 		bit	TX91	@ (unsigned)&TXSTA1*8+6;
static 		bit	TXEN1	@ (unsigned)&TXSTA1*8+5;
static 		bit	SYNC1	@ (unsigned)&TXSTA1*8+4;
static volatile	bit	TRMT1	@ (unsigned)&TXSTA1*8+1;
static 		bit	TX9D1	@ (unsigned)&TXSTA1*8+0;

/*      PORTC bits      */
static volatile bit      RC7     @ (unsigned)&PORTC*8+7;
static volatile bit      RC6     @ (unsigned)&PORTC*8+6;
static volatile bit      RC5     @ (unsigned)&PORTC*8+5;
static volatile bit      RC4     @ (unsigned)&PORTC*8+4;
static volatile bit      RC3     @ (unsigned)&PORTC*8+3;
static volatile bit      RC2     @ (unsigned)&PORTC*8+2;
static volatile bit      RC1     @ (unsigned)&PORTC*8+1;
static volatile bit      RC0     @ (unsigned)&PORTC*8+0;

/*      PORTD bits      */
static volatile bit      RD7     @ (unsigned)&PORTD*8+7;
static volatile bit      RD6     @ (unsigned)&PORTD*8+6;
static volatile bit      RD5     @ (unsigned)&PORTD*8+5;
static volatile bit      RD4     @ (unsigned)&PORTD*8+4;
static volatile bit      RD3     @ (unsigned)&PORTD*8+3;
static volatile bit      RD2     @ (unsigned)&PORTD*8+2;
static volatile bit      RD1     @ (unsigned)&PORTD*8+1;
static volatile bit      RD0     @ (unsigned)&PORTD*8+0;

/*      PORTE bits      */
static volatile bit        RE3     @ (unsigned)&PORTE*8+3;
static volatile bit        RE2     @ (unsigned)&PORTE*8+2;
static volatile bit        RE1     @ (unsigned)&PORTE*8+1;
static volatile bit        RE0     @ (unsigned)&PORTE*8+0;

/*	PIR1 bits	*/
static volatile	bit	RBIF	@ (unsigned)&PIR1*8+7;
static volatile	bit	TMR3IF	@ (unsigned)&PIR1*8+6;
static volatile	bit	TMR2IF	@ (unsigned)&PIR1*8+5;
static volatile	bit	TMR1IF	@ (unsigned)&PIR1*8+4;
static volatile	bit	CA2IF	@ (unsigned)&PIR1*8+3;
static volatile	bit	CA1IF	@ (unsigned)&PIR1*8+2;
static volatile	bit	TX1IF	@ (unsigned)&PIR1*8+1;
static volatile	bit	RC1IF	@ (unsigned)&PIR1*8+0;

/*	PIE1 bits	*/
static 		bit	RBIE	@ (unsigned)&PIE1*8+7;
static 		bit	TMR3IE	@ (unsigned)&PIE1*8+6;
static 		bit	TMR2IE	@ (unsigned)&PIE1*8+5;
static 		bit	TMR1IE	@ (unsigned)&PIE1*8+4;
static 		bit	CA2IE	@ (unsigned)&PIE1*8+3;
static 		bit	CA1IE	@ (unsigned)&PIE1*8+2;
static 		bit	TX1IE	@ (unsigned)&PIE1*8+1;
static 		bit	RC1IE	@ (unsigned)&PIE1*8+0;

/*      PW1DCL bits     */
static bit        DC1PW1  @ (unsigned)&PW1DCL*8+7;
static bit        DC0PW1  @ (unsigned)&PW1DCL*8+6;

/*      PW2DCL  bits    */
static bit        DC1PW2  @ (unsigned)&PW2DCL*8+7;
static bit        DC0PW2  @ (unsigned)&PW2DCL*8+6;
static bit        TM2PW2  @ (unsigned)&PW2DCL*8+5;

/*      PW1DCH bits     */
static bit        DC9PW1  @ (unsigned)&PW1DCH*8+7;
static bit        DC8PW1  @ (unsigned)&PW1DCH*8+6;
static bit        DC7PW1  @ (unsigned)&PW1DCH*8+5;
static bit        DC6PW1  @ (unsigned)&PW1DCH*8+4;
static bit        DC5PW1  @ (unsigned)&PW1DCH*8+3;
static bit        DC4PW1  @ (unsigned)&PW1DCH*8+2;
static bit        DC3PW1  @ (unsigned)&PW1DCH*8+1;
static bit        DC2PW1  @ (unsigned)&PW1DCH*8+0;

/*      PW2DCH bits     */
static bit        DC9PW2  @ (unsigned)&PW2DCH*8+7;
static bit        DC8PW2  @ (unsigned)&PW2DCH*8+6;
static bit        DC7PW2  @ (unsigned)&PW2DCH*8+5;
static bit        DC6PW2  @ (unsigned)&PW2DCH*8+4;
static bit        DC5PW2  @ (unsigned)&PW2DCH*8+3;
static bit        DC4PW2  @ (unsigned)&PW2DCH*8+2;
static bit        DC3PW2  @ (unsigned)&PW2DCH*8+1;
static bit        DC2PW2  @ (unsigned)&PW2DCH*8+0;

/*	TCON1 bits	*/
static 		bit	CA2ED1	@ (unsigned)&TCON1*8+7;
static 		bit	CA2ED0	@ (unsigned)&TCON1*8+6;
static 		bit	CA1ED1	@ (unsigned)&TCON1*8+5;
static 		bit	CA1ED0	@ (unsigned)&TCON1*8+4;
static 		bit	T16	@ (unsigned)&TCON1*8+3;
static 		bit	TMR3CS	@ (unsigned)&TCON1*8+2;
static 		bit	TMR2CS	@ (unsigned)&TCON1*8+1;
static 		bit	TMR1CS	@ (unsigned)&TCON1*8+0;

/*	TCON2 bits	*/
static volatile	bit	CA2OVF	@ (unsigned)&TCON2*8+7;
static volatile	bit	CA1OVF	@ (unsigned)&TCON2*8+6;
static 		bit	PWM2ON	@ (unsigned)&TCON2*8+5;
static 		bit	PWM1ON	@ (unsigned)&TCON2*8+4;
static 		bit	CA1	@ (unsigned)&TCON2*8+3;
static 		bit	TMR3ON	@ (unsigned)&TCON2*8+2;
static 		bit	TMR2ON	@ (unsigned)&TCON2*8+1;
static 		bit	TMR1ON	@ (unsigned)&TCON2*8+0;

/*	PIR2 bits	*/
static volatile	bit	SSPIF	@ (unsigned)&PIR2*8+7;
static volatile	bit	BCLIF	@ (unsigned)&PIR2*8+6;
static volatile	bit	ADIF	@ (unsigned)&PIR2*8+5;
static volatile	bit	CA4IF	@ (unsigned)&PIR2*8+3;
static volatile	bit	CA3IF	@ (unsigned)&PIR2*8+2;
static volatile	bit	TX2IF	@ (unsigned)&PIR2*8+1;
static volatile	bit	RC2IF	@ (unsigned)&PIR2*8+0;

/*	PIE2 bits	*/
static 		bit	SSPIE	@ (unsigned)&PIE2*8+7;
static 		bit	BCLIE	@ (unsigned)&PIE2*8+6;
static 		bit	ADIE	@ (unsigned)&PIE2*8+5;
static 		bit	CA4IE	@ (unsigned)&PIE2*8+3;
static 		bit	CA3IE	@ (unsigned)&PIE2*8+2;
static 		bit	TX2IE	@ (unsigned)&PIE2*8+1;
static 		bit	RC2IE	@ (unsigned)&PIE2*8+0;

/*	RCSTA2 bits	*/
static 		bit	SPEN2	@ (unsigned)&RCSTA2*8+7;
static 		bit	RX92	@ (unsigned)&RCSTA2*8+6;
static 		bit	SREN2	@ (unsigned)&RCSTA2*8+5;
static 		bit	CREN2	@ (unsigned)&RCSTA2*8+4;
static volatile	bit	FERR2	@ (unsigned)&RCSTA2*8+2;
static volatile	bit	OERR2	@ (unsigned)&RCSTA2*8+1;
static volatile	bit	RX9D2	@ (unsigned)&RCSTA2*8+0;

/*	TXSTA2 bits	*/
static 		bit	CSRC2	@ (unsigned)&TXSTA2*8+7;
static 		bit	TX92	@ (unsigned)&TXSTA2*8+6;
static 		bit	TXEN2	@ (unsigned)&TXSTA2*8+5;
static 		bit	SYNC2	@ (unsigned)&TXSTA2*8+4;
static volatile	bit	TRMT2	@ (unsigned)&TXSTA2*8+1;
static 		bit	TX9D2	@ (unsigned)&TXSTA2*8+0;

/*      PORTF bits      */
static volatile bit        RF7     @ (unsigned)&PORTF*8+7;
static volatile bit        RF6     @ (unsigned)&PORTF*8+6;
static volatile bit        RF5     @ (unsigned)&PORTF*8+5;
static volatile bit        RF4     @ (unsigned)&PORTF*8+4;
static volatile bit        RF3     @ (unsigned)&PORTF*8+3;
static volatile bit        RF2     @ (unsigned)&PORTF*8+2;
static volatile bit        RF1     @ (unsigned)&PORTF*8+1;
static volatile bit        RF0     @ (unsigned)&PORTF*8+0;

/*      PORTG bits      */
static volatile bit        RG7     @ (unsigned)&PORTG*8+7;
static volatile bit        RG6     @ (unsigned)&PORTG*8+6;
static volatile bit        RG5     @ (unsigned)&PORTG*8+5;
static volatile bit        RG4     @ (unsigned)&PORTG*8+4;
static volatile bit        RG3     @ (unsigned)&PORTG*8+3;
static volatile bit        RG2     @ (unsigned)&PORTG*8+2;
static volatile bit        RG1     @ (unsigned)&PORTG*8+1;
static volatile bit        RG0     @ (unsigned)&PORTG*8+0;

/*	ADCON0 bits	*/
static 		bit	CHS3	@ (unsigned)&ADCON0*8+7;
static 		bit	CHS2	@ (unsigned)&ADCON0*8+6;
static 		bit	CHS1	@ (unsigned)&ADCON0*8+5;
static 		bit	CHS0	@ (unsigned)&ADCON0*8+4;
static volatile	bit	GO	@ (unsigned)&ADCON0*8+2;
static 		bit	ADON	@ (unsigned)&ADCON0*8+0;

/*	ADCON1 bits	*/
static 		bit	ADCS1	@ (unsigned)&ADCON1*8+7;
static 		bit	ADCS0	@ (unsigned)&ADCON1*8+6;
static 		bit	ADFM	@ (unsigned)&ADCON1*8+5;
static 		bit	PCFG3	@ (unsigned)&ADCON1*8+3;
static 		bit	PCFG2	@ (unsigned)&ADCON1*8+2;
static 		bit	PCFG1	@ (unsigned)&ADCON1*8+1;
static 		bit	PCFG0	@ (unsigned)&ADCON1*8+0;

/*	SSPCON1 bits	*/
static volatile	bit	WCOL	@ (unsigned)&SSPCON1*8+7;
static volatile	bit	SSPOV	@ (unsigned)&SSPCON1*8+6;
static 		bit	SSPEN	@ (unsigned)&SSPCON1*8+5;
static 		bit	CKP	@ (unsigned)&SSPCON1*8+4;
static 		bit	SSPM3	@ (unsigned)&SSPCON1*8+3;
static 		bit	SSPM2	@ (unsigned)&SSPCON1*8+2;
static 		bit	SSPM1	@ (unsigned)&SSPCON1*8+1;
static 		bit	SSPM0	@ (unsigned)&SSPCON1*8+0;

/*	SSPCON2 bits	*/
static 		bit	GCEN	@ (unsigned)&SSPCON2*8+7;
static volatile	bit	ACKSTAT	@ (unsigned)&SSPCON2*8+6;
static 		bit	ACKDT	@ (unsigned)&SSPCON2*8+5;
static 		bit	ACKEN	@ (unsigned)&SSPCON2*8+4;
static 		bit	RCEN	@ (unsigned)&SSPCON2*8+3;
static volatile	bit	PEN	@ (unsigned)&SSPCON2*8+2;
static volatile	bit	RSEN	@ (unsigned)&SSPCON2*8+1;
static volatile	bit	SEN	@ (unsigned)&SSPCON2*8+0;

/*      SSPSTAT bits    */
static bit        STAT_SMP        @ (unsigned)&SSPSTAT*8+7;
static bit        STAT_CKE        @ (unsigned)&SSPSTAT*8+6;
static bit        STAT_DA         @ (unsigned)&SSPSTAT*8+5;
static bit        STAT_P          @ (unsigned)&SSPSTAT*8+4;
static bit        STAT_S          @ (unsigned)&SSPSTAT*8+3;
static bit        STAT_RW         @ (unsigned)&SSPSTAT*8+2;
static bit        STAT_UA         @ (unsigned)&SSPSTAT*8+1;
static bit        STAT_BF         @ (unsigned)&SSPSTAT*8+0;

/*      PW3DCL  bits    */
static bit        DC1PW3  @ (unsigned)&PW3DCL*8+7;
static bit        DC0PW3  @ (unsigned)&PW3DCL*8+6;
static bit        TM2PW3  @ (unsigned)&PW3DCL*8+5;

/*      PW3DCH bits     */
static bit        DC9PW3  @ (unsigned)&PW3DCH*8+7;
static bit        DC8PW3  @ (unsigned)&PW3DCH*8+6;
static bit        DC7PW3  @ (unsigned)&PW3DCH*8+5;
static bit        DC6PW3  @ (unsigned)&PW3DCH*8+4;
static bit        DC5PW3  @ (unsigned)&PW3DCH*8+3;
static bit        DC4PW3  @ (unsigned)&PW3DCH*8+2;
static bit        DC3PW3  @ (unsigned)&PW3DCH*8+1;
static bit        DC2PW3  @ (unsigned)&PW3DCH*8+0;

/*	TCON3 bits	*/
static volatile	bit	CA4OVF	@ (unsigned)&TCON3*8+6;
static volatile	bit	CA3OVF	@ (unsigned)&TCON3*8+5;
static 		bit	CA4ED1	@ (unsigned)&TCON3*8+4;
static 		bit	CA4ED0	@ (unsigned)&TCON3*8+3;
static 		bit	CA3ED1	@ (unsigned)&TCON3*8+2;
static 		bit	CA3ED0	@ (unsigned)&TCON3*8+1;
static 		bit	PWM3ON	@ (unsigned)&TCON3*8+0;

#if defined(_17C762) || defined(_17C766)
/*      PORTH bits      */
static volatile bit        RH7     @ (unsigned)&PORTH*8+7;
static volatile bit        RH6     @ (unsigned)&PORTH*8+6;
static volatile bit        RH5     @ (unsigned)&PORTH*8+5;
static volatile bit        RH4     @ (unsigned)&PORTH*8+4;
static volatile bit        RH3     @ (unsigned)&PORTH*8+3;
static volatile bit        RH2     @ (unsigned)&PORTH*8+2;
static volatile bit        RH1     @ (unsigned)&PORTH*8+1;
static volatile bit        RH0     @ (unsigned)&PORTH*8+0;

/*      PORTJ bits      */
static volatile bit        RJ7     @ (unsigned)&PORTJ*8+7;
static volatile bit        RJ6     @ (unsigned)&PORTJ*8+6;
static volatile bit        RJ5     @ (unsigned)&PORTJ*8+5;
static volatile bit        RJ4     @ (unsigned)&PORTJ*8+4;
static volatile bit        RJ3     @ (unsigned)&PORTJ*8+3;
static volatile bit        RJ2     @ (unsigned)&PORTJ*8+2;
static volatile bit        RJ1     @ (unsigned)&PORTJ*8+1;
static volatile bit        RJ0     @ (unsigned)&PORTJ*8+0;
#endif

#if	0
/*	TSTMD1 bits	*/
static bit	FPMM2	@ (unsigned)&TSTMD1*8+7;
static bit	BODEN1	@ (unsigned)&TSTMD1*8+6;
static bit	ADTST	@ (unsigned)&TSTMD1*8+0;

/*	TSTMD2 bits	*/
static bit	TSTMUX	@ (unsigned)&TSTMD2*8+7;
static bit	FPMM1	@ (unsigned)&TSTMD2*8+6;
static bit	GLWP	@ (unsigned)&TSTMD2*8+5;
static bit	FPMM0	@ (unsigned)&TSTMD2*8+4;
static bit	NWDT1	@ (unsigned)&TSTMD2*8+3;
static bit	NWDT0	@ (unsigned)&TSTMD2*8+2;
static bit	SOSC1	@ (unsigned)&TSTMD2*8+1;
static bit	SOSC0	@ (unsigned)&TSTMD2*8+0;
#endif

//Marko's own definitions
	/*  DDRB Bits	*/
static 		bit	DDRB7	@ (unsigned)&DDRB*8+7;
static 		bit	DDRB6	@ (unsigned)&DDRB*8+6;
static 		bit	DDRB5	@ (unsigned)&DDRB*8+5;
static 		bit	DDRB4	@ (unsigned)&DDRB*8+4;
static 		bit	DDRB3	@ (unsigned)&DDRB*8+3;
static 		bit	DDRB2	@ (unsigned)&DDRB*8+2;
static 		bit	DDRB1	@ (unsigned)&DDRB*8+1;
static 		bit	DDRB0	@ (unsigned)&DDRB*8+0;

	/*  DDRC Bits	*/
static 		bit	DDRC7	@ (unsigned)&DDRC*8+7;
static 		bit	DDRC6	@ (unsigned)&DDRC*8+6;
static 		bit	DDRC5	@ (unsigned)&DDRC*8+5;
static 		bit	DDRC4	@ (unsigned)&DDRC*8+4;
static 		bit	DDRC3	@ (unsigned)&DDRC*8+3;
static 		bit	DDRC2	@ (unsigned)&DDRC*8+2;
static 		bit	DDRC1	@ (unsigned)&DDRC*8+1;
static 		bit	DDRC0	@ (unsigned)&DDRC*8+0;

	/*  DDRD Bits	*/
static 		bit	DDRD7	@ (unsigned)&DDRD*8+7;
static 		bit	DDRD6	@ (unsigned)&DDRD*8+6;
static 		bit	DDRD5	@ (unsigned)&DDRD*8+5;
static 		bit	DDRD4	@ (unsigned)&DDRD*8+4;
static 		bit	DDRD3	@ (unsigned)&DDRD*8+3;
static 		bit	DDRD2	@ (unsigned)&DDRD*8+2;
static 		bit	DDRD1	@ (unsigned)&DDRD*8+1;
static 		bit	DDRD0	@ (unsigned)&DDRD*8+0;

	/*  DDRE Bits	*/
static 		bit	DDRE3	@ (unsigned)&DDRE*8+3;
static 		bit	DDRE2	@ (unsigned)&DDRE*8+2;
static 		bit	DDRE1	@ (unsigned)&DDRE*8+1;
static 		bit	DDRE0	@ (unsigned)&DDRE*8+0;

	/*  DDRF Bits	*/
static 		bit	DDRF7	@ (unsigned)&DDRF*8+7;
static 		bit	DDRF6	@ (unsigned)&DDRF*8+6;
static 		bit	DDRF5	@ (unsigned)&DDRF*8+5;
static 		bit	DDRF4	@ (unsigned)&DDRF*8+4;
static 		bit	DDRF3	@ (unsigned)&DDRF*8+3;
static 		bit	DDRF2	@ (unsigned)&DDRF*8+2;
static 		bit	DDRF1	@ (unsigned)&DDRF*8+1;
static 		bit	DDRF0	@ (unsigned)&DDRF*8+0;

	/*  DDRG Bits	*/
static 		bit	DDRG7	@ (unsigned)&DDRG*8+7;
static 		bit	DDRG6	@ (unsigned)&DDRG*8+6;
static 		bit	DDRG5	@ (unsigned)&DDRG*8+5;
static 		bit	DDRG4	@ (unsigned)&DDRG*8+4;
static 		bit	DDRG3	@ (unsigned)&DDRG*8+3;
static 		bit	DDRG2	@ (unsigned)&DDRG*8+2;
static 		bit	DDRG1	@ (unsigned)&DDRG*8+1;
static 		bit	DDRG0	@ (unsigned)&DDRG*8+0;
