void discharge()
{
 DDRE1 = 0;			//discharge resistor pin output
 RE1   = 0;			//discharge capacitor
 DelayMs(1);			//wait for 1ms
 DDRE1 = 1;			//set discharge resistor pin tristate again
}


void init_timer1_2_for_timer_in_16bit_mode()
{
 T16 	= 1;		//timer 1&2 are no one 16bit timer
 TMR1CS	= 0;		//timer mode (CLK = Fosc/4)
 TMR2ON = 1;		//connect timer2 with timer1
 TMR1ON = 0;		//stop timer
 TMR1   = 0;		//clear register
 TMR2	= 0;		//clear register
}


unsigned int calibration_value()
{
 init_timer1_2_for_timer_in_16bit_mode();   	//prepare TIMER1 as a stopwatch
 RE0    = 0;
 DDRE0  = 0;
 RE0    = 0;
 discharge();			//discharge capacitor with RE1
 TMR1ON = 1;			//start TIMER1 as a stopwatch
 RE0    = 1;			//start Charge process
 while(!RE1);			//wait until threshold RE1=1
 TMR1ON = 0;			//stop  TIMER1 as a stopwatch
 RE0    = 0;
 DDRE0  = 1;			//set calibrationpin RC2 tristate
 return 256*TMR2 + TMR1; 	//make the 16 bit timer result to a interger number
}

unsigned int thermistor_value()
{
 init_timer1_2_for_timer_in_16bit_mode();   	//prepare TIMER1 as a stopwatch
 RD0    = 0;
 DDRD0  = 0;
 RD0    = 0;
 discharge();			//discharge capacitor with RE1
 TMR1ON = 1;			//start TIMER1 as a stopwatch
 RD0    = 1;			//start Charge process
 while(!RE1);			//wait until threshold RE1=1
 TMR1ON = 0;			//stop  TIMER1 as a stopwatch
 RD0    = 0;
 DDRD0  = 1;			//set calibrationpin RC2 tristate
 return 256*TMR2 + TMR1; 	//make the 16 bit timer result to a interger number
}  
 


float temperature()
{
 unsigned char	save_GLINTD;
 float		temp;

 save_GLINTD = GLINTD;	//save the status of global interupt permission
 GLINTD      = 1;	//no interupt permited
 
 temp = calibration_value();
 temp = (temp / thermistor_value()) + Bottom_global;
 temp = V50_global - Slope_global * log((TOP_global + Bottom_global) / temp - 1);

 GLINTD = save_GLINTD;	/*restore interuptpermition       */
 return temp; 
}


/*
void temperature_test()
{
 unsigned int 	help1, help2;
 float		helpf;

 while(1)
 {
  discharge();
  help1 = calibration_value();

  discharge();
  help2 = thermistor_value();

  helpf = temperature();

  printf("\nKal.-Wert = %u  Therm.-Wert = %u  Temp=%3.1foC", help1, help2, helpf);
//  DelayMs(2000);
 }
}
*/
