static bit LATI	@ ((unsigned)&PORTC*8+0);	// Latch
static bit SID	@ ((unsigned)&PORTC*8+1);	// Data
static bit SCK	@ ((unsigned)&PORTC*8+2);	// Clock
static bit MUTE	@ ((unsigned)&PORTC*8+5);	// Mute

#define	ML2036_clock ((SCK = 0),(SCK = 1),(SCK = 0))	//define the clock for the out-shifting of the 16bit word

void init_ML2036()
{
 TRISC0  = 0;	//set pint to the ML2036 as outputs
 TRISC1  = 0;
 TRISC2  = 0;
 TRISC5  = 0;	//set mute pin as output

 MUTE	 = 0;	//loudspeaker on
 LATI    = 0;	//set the latch to 0
}

void frequency(unsigned int frequency_value)
{
 unsigned char i;	//The outputfrequency is the frequency_value * 1.192093
 unsigned int  mask;	//if a 10MHz clock is provided
   	 		//see datasheet therefore
 mask = 1;
 LATI = 0;

 frequency_value = frequency_value * 0.83886;	//correction factor for a 10MHz crystal

 for (i=0; i<16; i++)
 {
  if (mask & frequency_value) SID = 1;	//shift out all bit 
   else SID = 0;
  ML2036_clock;				//generate a clock signal
  mask = mask*2;			//mask the next higher bit
 }
 LATI = 1; LATI = 0;	//latch the word into the chip register
}

void load_sound(unsigned int climb_value)
{
 unsigned int	frequenz;	//example for frequencies  climb_value
				//  100Hz with -5m/s  	=   1500
				//  800Hz with  0m/s	=   2000
				// 3000Hz with  5m/s 	=   2500

 float	Span	= 5.718	  	,	//this parameters are fitting
	K	= 0.002519	,	//the exponetial function below
	Plateau	= 101.2		;	//into the values above
             
 last_climb_value = climb_value;

 frequenz = Span*exp(K * climb_value) - Plateau;
 frequency(frequenz);
					//calculation of the 
					//delay time for positive climb rate
 delay_time = 2000000 / frequenz;	//2Hz delay frequenz with 0m/s
					//8Hz delay frequenz with 5m/s
 if (climb_value < 2001) delay_time = 0;//stop the sound interrupt routine for positive climb rates immediately
}
