void init_interrupt()
{
 RCIE = 1;	//enable overflow interrupt
 PEIE = 1;	//enable device interrupt permission
		//everything what's left to do is to enable the global interrupt permission
}

void instruction_execution()
{
 if ((command & 0xF0) == 0b00010000)			// 1 - if data==0 then mute, else the sound will be on
 {
  if (data == 0) sound(0);			
   else          sound(1);
  mode = leerlauf;
 }
 if ((command & 0xF0) == 0b00100000)			// 2 - sollfahrt mode
 {
  load_sound((command & 0x0F) * 0x100 + data);		//     blind the command nibble out, shift the high nibble to the high byte low nible and add data to the low-byte		
  mode = sollfahrt;					//     set the mode in the main loop for sollfahrt	
 } 
 if ((command & 0xF0) == 0b00110000)			// 3 - vario mode
 {
  load_sound((command & 0x0F) * 0x100 + data);		//     blind the command nibble out, shift the high nibble to the high byte low nible and add data to the low-byte		
  mode = vario;						//     set the mode in the main loop for vario
 } 
 if ((command & 0xF0) == 0b01000000) volume(data);	// 4 - set volume; 0 = silence, 255 = full volume
}


interrupt void serial_interrupt()
{
 while (OERR==0);	//wait for the third byte which will course the overflow

 command = RCREG;	//read high and low_byte byte from buffer
 data    = RCREG;

 instruction_execution();

 gotoxy_int(1,1); lcd_puts_int("after   ");
 gotoxy_int(1,2); lcd_puts_int("instrEXE");

 CREN = 0;		//reset UART for clearing the OERR bit
 CREN = 1;
}


void sound_main_loop()
{
// unsigned char	j;
// unsigned int		i;

 delay_time = 0;		//each 1000 delay_time = 100ms
 mode = leerlauf;
 sollfahrt_tolleranz = 50;	//sound off for a sollfahrt error of 0.5m/s

 GIE = 1;			//init global interrupt permission

 gotoxy(1,1); lcd_puts("mainloop");
 gotoxy(1,2); lcd_puts("started ");

 while(1)
 {
  gotoxy(1,1); lcd_puts("inside  ");
  gotoxy(1,2); lcd_puts("mainloop");

  while (mode == leerlauf)
  {
  }
  while (mode == vario)		//switch sound on and off depending from the climb rate
  {				//the on/off time is calculated in the load sound routine
   gotoxy(1,1); lcd_puts("Vario-  ");
   gotoxy(1,2); lcd_puts("   mode ");

   interrupt_extern_sound(0);
   DelayMs(200);
   interrupt_extern_sound(1);
   DelayMs(200);
  }
  while (mode == sollfahrt)		//continue sound except a range in the tollerance
  {					//in tollerance range the sound is off
   gotoxy(1,1); lcd_puts("Sollfahr");
   gotoxy(1,2); lcd_puts("-mode   ");

   if ((last_climb_value < (2000 + sollfahrt_tolleranz)) & (last_climb_value > (2000 - sollfahrt_tolleranz))) interrupt_extern_sound(0);
    else interrupt_extern_sound(1);
  }
 }

}
